program BACKSUBSTITUTION;
{--------------------------------------------------------------------}
{  Alg3'1.pas   Pascal program for implementing Algorithm 3.1        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 3.1 (Back Substitution).                                }
{  Section   3.3, Upper-Triangular Linear Systems, Page 145           }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    MaxR = 10;

  type
    MATRIX = array[1..MaxR, 1..MaxR] of real;
    VECTOR = array[1..MaxR] of real;
    LETTERS = string[200];
    STATUS = (Done, Working);

  var
    Hor, InRC, Inum, N, Sub, Ver: integer;
    DET, Rnum: real;
    A: MATRIX;
    B, X: VECTOR;
    Ans: CHAR;
    Mess: LETTERS;
    Stat: STATUS;

  procedure BACKSUB (A: MATRIX; B: VECTOR; N: integer; var X: VECTOR; var DET: real);
    label
      999;
    var
      J, K, R: integer;
      SUM: real;
  begin
    for K := 1 to N do                          {Check singular matrix}
      begin
        if A[K, K] = 0 then
          begin
            DET := 0;
            goto 999;
          end;
      end;
    DET := A[N, N];
    X[N] := B[N] / A[N, N];                        {Start back substitution}
    for R := N - 1 downto 1 do
      begin
        DET := DET * A[R, R];
        SUM := 0;
        for J := R + 1 to N do
          SUM := SUM + A[R, J] * X[J];
        X[R] := (B[R] - SUM) / A[R, R];
      end;
999:
  end;                                       {End of procedure BACKSUB}

  procedure INPUT (var A: MATRIX; var B: VECTOR; var N: integer);
    var
      C, R: integer;
  begin
    CLRSCR;
    for R := 1 to N do
      for C := 1 to N do
        A[R, C] := 0;
    for R := 1 to N do
      B[R] := 0;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('Solution of an upper-triangular linear system  A*X = B.');
    WRITELN;
    Mess := 'ENTER the number of equations  N = ';
    WRITE(Mess);
    READLN(N);
    if N < 2 then
      N := 2;
    if N > 10 then
      N := 10;
    WRITELN;
    WRITELN;
    WRITELN('You can enter coefficients of A in rows or columns.');
    WRITELN;
    WRITELN;
    WRITELN('< 1 >  Enter the rows of  A.');
    WRITELN;
    WRITELN;
    WRITELN('< 2 >  Enter the columns of  A.');
    WRITELN;
    WRITELN;
    Mess := 'SELECT < 1 or 2 > ?  ';
    InRC := 1;
    WRITE(Mess);
    READLN(InRC);
    if (InRC < 1) or (InRC > 2) then
      InRC := 1;
      CLRSCR;
    WRITELN('Enter the upper-triangular matrix of coefficients.');
    if InRC = 1 then
      begin
        for R := 1 to N do
          begin
            WRITELN('ENTER the coefficients of row ', R);
            WRITELN;
            for C := R to N do
              begin
                WRITE('A(', R : 2, ',', C : 2, ') = ');
                READLN(A[R, C]);
              end;
          end;
      end
    else
      begin
        for C := 1 to N do
          begin
            WRITELN('ENTER the coefficients of column ', C);
            WRITELN;
            for R := 1 to C do
              begin
                WRITE('A(', R : 2, ',', C : 2, ') = ');
                READLN(A[R, C]);
              end;
          end;
      end;
    WRITELN('ENTER the column vector.');
    WRITELN;
    for R := 1 to N do
      begin
        WRITE('B(', R : 2, ') = ');
        READLN(B[R]);
      end;
  end;                                         {End of procedure INPUT}

  procedure MESSAGE (var InRC: integer);
    var
      C, R: integer;
      Ans: CHAR;
  begin
    CLRSCR;
    WRITELN('                          BACK SUBSTITUTION');
    WRITELN;
    WRITELN('     Solution of an upper-triangular linear system.');
    WRITELN;
    WRITELN('     a   x  + a   x   + a   x  + ... +   a     x    +   a   x   =  b ');
    WRITELN('      1,1 1    1,2 2     1,3 3            1,N-1 N-1      1,N N      1');
    WRITELN;
    WRITELN('              a   x   + a   x  + ... +   a     x    +   a   x   =  b ');
    WRITELN('               2,2 2     2,3 3            2,N-1 N-1      2,N N      2');
    WRITELN;
    WRITELN('                            .                  .            .      .');
    WRITELN('                            :                  :            :      :');
    WRITELN;
    WRITELN('                        a   x  + ... +   a     x    +   a   x   =  b ');
    WRITELN('                         3,3 3            3,N-1 N-1      3,N N      3');
    WRITELN;
    WRITELN('                                       a       x    + a     x   =  b ');
    WRITELN('                                        N-1,N-1 N-1    N-1,N N      N-1');
    WRITELN;
    WRITELN('                                                        a   x   =  b ');
    WRITELN('                                                         N,N N      N');
    WRITELN;
    WRITELN('     The diagonal coefficients must be non-zero. ');
    WRITELN;
    WRITE('                          Press the <ENTER> key. ');
    READLN(Ans);
    CLRSCR;
  end;

  procedure RESULTS (A: MATRIX; B: VECTOR; N: integer; X: VECTOR; DET: real);
    label
      999;
    var
      C, R: integer;
  begin
    CLRSCR;
    WRITELN;                                                   {Output}
    WRITELN('The matrix A(R,C) is:');
    WRITELN;
    for R := 1 to N do
      begin
        for C := 1 to N do
          begin
            if C < R then
              WRITE('                ')
            else if C < N then
              WRITE(A[R, C] : 15 : 7, ' ')
            else
              WRITE(A[R, N] : 15 : 7);
          end;
        WRITELN;
      end;
    WRITELN;
    if DET = 0 then                             {Check singular matrix}
      begin
        WRITELN('The matrix is singular.');
        WRITELN;
        WRITELN('The back-substitution algorithm does not apply.');
        goto 999;
      end;
    WRITELN('Column vector B(R):          Solution vector X(R):');
    for R := 1 to N do
      begin
        WRITELN;
        WRITE('B(', R : 2, ') = ', B[R] : 15 : 7, '       ');
        WRITE('X(', R : 2, ') = ', X[R] : 15 : 7);
      end;
    WRITELN;
999:
    WRITELN;
    WRITELN('The determinant`s value is  Det(A) = ', DET : 15 : 7);
    WRITELN;
  end;                                       {End of procedure RESULTS}

begin                                              {The Main Program}
  Stat := Working;
  MESSAGE(InRC);
  while (Stat = Working) do
    begin
      N := MaxR;
      INPUT(A, B, N);
      BACKSUB(A, B, N, X, DET);
      RESULTS(A, B, N, X, DET);
      WRITE('Want  to  solve  another  problem ? <Y/N>  ');
      READLN(Ans);
      if (Ans <> 'Y') and (Ans <> 'y') then
        Stat := Done
    end;
end.                                            {End of Main Program}

